
//returns an html string for the tutorial header
function getHeader() {
   var header = '';
   header += '<table cellspacing="0" cellpadding="0" width="100%" border="0">';
   header +=    '<tr bgcolor="#899ca9">';
   header +=       '<td align="left"><img alt="" src="interop/template_theme1/windchill_logo.jpg" border="0"/></td>';
   header +=       '<td align="right"><a href="http://www.ptc.com" target="_blank"><img src="interop/template_theme1/ptc_logo.jpg" border="0"/></a></td>';
   header +=    '</tr>';
   header +=    '<tr bgcolor="#3b5a6f" height="25px" ><td colspan="2"></td></tr>';
   header += '</table>';
   header += '<br>';

   return header;
}

//returns an html string that is a listing of all the topics as links
function getTableOfContents() {
   tableOfContentsString = "";
   mainMenu = topicStructure.getItemFromName( tutorialMenuArray[0].name );
   for( var i = 0; i<mainMenu.subs.length; i++) {
      subMenu = mainMenu.subs[i];
      tableOfContentsString += getSectionFor( subMenu, subMenu.text );
   }
   tableOfContentsString = '<table width="100%" border=0 cellpadding="10px"><tr><td>' + tableOfContentsString + '</td></tr></table>';
   return tableOfContentsString;
}

//returns an html string that is a listing of one section of topics as links
//there are 3 sections: Windchill Operations, Products and Product Data Management, Projects and Project Collaboration
function getSectionFor( aMenu, title ) {
   sectionString = "<div class='tableOfContentsTitle'>"+ title +"</div>"
   sectionString += "<hr>"
   sectionString += "<table width='100%'><tr>"
   tdBegin = "<td valign='top'>"
   tdArray = [tdBegin, tdBegin, tdBegin]
   j = 0
   //split the lists evenly between three <td> columns
   for( var i = 0; i<aMenu.subs.length; i++) {
      tdArray[j%tdArray.length] += getListFor( aMenu.subs[i], "" ) + "<br>";
      j++
   }
   //close with </td>
   for( var i=0; i<tdArray.length; i++ ) {
      tdArray[i] += "</td>"
      sectionString += tdArray[i]
   }
   sectionString += "</tr></table><br>"
   return sectionString
}

//returns an html string that is a listing of links
function getListFor( thisMenu, indent ) {
   listString = "";
   if( thisMenu ) {
      if( thisMenu.link ) { 
         listString += indent + "<a class='tableOfContentsLink' href='" + thisMenu.link + "'>" + thisMenu.text + "</a><br>"
      } else {
         listString += "<div class='tableOfContentsSubTitle'>" + indent + thisMenu.text + "</div>"
      }
      for( var i = 0; i<thisMenu.subs.length; i++ ) {
         menu = thisMenu.subs[i];
         if( menu.subs.length > 0 ) {
            //add an indent for these items so they appear nested beneath their main topic
            listString += getListFor( menu, "<span style='{font-size:.6em}'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>" );
         } else {
            listString += indent + "<a class='tableOfContentsLink' href='"+menu.link+"'>"+menu.text+"</a><br>";
         }
      }
   }
   return listString
}

//a structure that contains items, each item can have subItems
function Structure( name ){
   this.name = name
   this.itemCount = 0 
   this.m = new Array()
   return this
}

//fills a structure with items from the menuArray 
Structure.prototype.fillStructure = function fillStructure( menuArray ) {
   if( menuArray ) {
      for( var i=0; i<menuArray.length; i++ ){
         this.addItem( menuArray[i] )
      }
   }
}

//add an item to a structure
Structure.prototype.addItem = function addItem( item ) {
   this.m[ this.m.length++ ] = item
   var parent = this.getItemFromName( item.parentName )
   item.lev = parent ? parent.lev+1 : 0
   item.subs = new Array()
   if( parent ) {
      parent.subs[ parent.subs.length++ ] = item
   }
}

//retrieve an item from a structure from it's name
Structure.prototype.getItemFromName = function getItemFromName( name ) {
   if( name != "" )
   for( var i=0; i<this.m.length; i++ ){
      if( name == this.m[i].name ) return this.m[i]
   }
   return null
}

//create a tutorialMenu item
function tutorialMenu( name, parentName, text, linkParameter ) {
   this.name=name
   this.parentName=parentName
   this.text=text
   this.link = linkParameter ? linkParameter : null
}
